VERSION 5.00
Begin VB.UserControl Sales_reps_SAP_mtnc 
   ClientHeight    =   8130
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15015
   ScaleHeight     =   8130
   ScaleWidth      =   15015
   Begin VB.Frame frm_detail 
      Caption         =   "#Detail"
      Height          =   2535
      Left            =   75
      TabIndex        =   0
      Tag             =   "frm_detail"
      Top             =   5295
      Visible         =   0   'False
      Width           =   13290
      Begin Project1.ArmCombobox cbo_SR_Code 
         Height          =   345
         Left            =   1155
         TabIndex        =   17
         Top             =   210
         Width           =   2900
         _ExtentX        =   5106
         _ExtentY        =   609
      End
      Begin VB.Frame fra_manipulation 
         Caption         =   "#Manipulation"
         Height          =   1185
         Left            =   135
         TabIndex        =   1
         Tag             =   "frm_maintenance"
         Top             =   705
         Width           =   9525
         Begin VB.CheckBox chk_dropped 
            Caption         =   "#Dropped"
            Height          =   255
            Left            =   6555
            TabIndex        =   7
            Tag             =   "chk_dropped"
            Top             =   780
            Width           =   1515
         End
         Begin VB.TextBox txt_dropDate 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   8250
            TabIndex        =   6
            Tag             =   "txt_dropDate"
            Text            =   "02/02/2001"
            Top             =   322
            Width           =   1095
         End
         Begin VB.TextBox txt_updUser 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   5
            Tag             =   "txt_updUser"
            Text            =   "L. Cockayne"
            Top             =   742
            Width           =   2415
         End
         Begin VB.TextBox txt_lastUpd 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   4
            Tag             =   "txt_lastUpd"
            Text            =   "02/02/2001"
            Top             =   742
            Width           =   1095
         End
         Begin VB.TextBox txt_creator 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   3
            Tag             =   "txt_creator"
            Text            =   "L. Cockayne"
            Top             =   322
            Width           =   2415
         End
         Begin VB.TextBox txt_Date 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   2
            Tag             =   "txt_Date"
            Text            =   "02/02/2001"
            Top             =   322
            Width           =   1095
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Drop date"
            Height          =   255
            Index           =   6
            Left            =   6660
            TabIndex        =   12
            Tag             =   "lbl_dropDate"
            Top             =   360
            Width           =   1530
         End
         Begin VB.Label lbl_label 
            Caption         =   "#By"
            Height          =   255
            Index           =   5
            Left            =   3150
            TabIndex        =   11
            Tag             =   "lbl_creator"
            Top             =   780
            Width           =   690
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Last updade"
            Height          =   255
            Index           =   4
            Left            =   150
            TabIndex        =   10
            Tag             =   "lbl_dateUpd"
            Top             =   780
            Width           =   1530
         End
         Begin VB.Label lbl_label 
            Caption         =   "#By"
            Height          =   255
            Index           =   3
            Left            =   3150
            TabIndex        =   9
            Tag             =   "lbl_ByUser"
            Top             =   360
            Width           =   690
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Creation date"
            Height          =   255
            Index           =   2
            Left            =   150
            TabIndex        =   8
            Tag             =   "lbl_date"
            Top             =   360
            Width           =   1530
         End
      End
      Begin Project1.ToolbarControl tlb_list 
         Height          =   1620
         Left            =   12405
         TabIndex        =   13
         Top             =   240
         Width           =   690
         _ExtentX        =   1217
         _ExtentY        =   2858
      End
      Begin Project1.ArmCombobox cbo_SR_SAP_Code 
         Height          =   345
         Left            =   6735
         TabIndex        =   18
         Top             =   210
         Width           =   2895
         _ExtentX        =   5371
         _ExtentY        =   609
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Sales rep."
         Height          =   270
         Index           =   0
         Left            =   90
         TabIndex        =   15
         Tag             =   "lbl_SR_Code"
         Top             =   285
         Width           =   945
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#SAP rep."
         Height          =   270
         Index           =   1
         Left            =   5730
         TabIndex        =   14
         Tag             =   "lbl_code_out"
         Top             =   285
         Width           =   945
      End
   End
   Begin Project1.ArmGrid grd_main 
      Height          =   4470
      Left            =   0
      TabIndex        =   16
      Top             =   -15
      Visible         =   0   'False
      Width           =   14865
      _ExtentX        =   26220
      _ExtentY        =   7885
   End
End
Attribute VB_Name = "Sales_reps_SAP_mtnc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long


Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const FRM_SPACE_VER = 120
Private Const FRM_SPACE_HOR = 100

Private Const SCREEN_NAME As String = "Sales_rep_SAP_Mtnc"
Private Const C_SCREENMODE_STACK_SIZE As Long = 5           ' size of stack for active screens
Private Const C_TLB_RPT_USER_MTNC_ID As Long = 140          ' ID of toolbar - the same for both details
Private Const C_TOOLBARFACE_ITEM_LST As String = "0"        ' toolbar for main list
Private Const C_TOOLBARFACE_ITEM_MTNC As String = "1"       ' for add, update
Private Const C_TOOLBARFACE_ITEM_MTNC2 As String = "2"       ' for delete

#If ENV = LIVE Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
    QuietException = vbObjectError + 13          ' do not display error message
    ErrMsgMandatoryAreEmpty = 2400 + 1
    WarMsgDoYouRemove = 2400 + 2
    ErrMsgIConcurency = 2400 + 3
    WarMsgSelectRow = 2400 + 4
    ErrCodeOutExists = 2440                     ' Code out already defined
    RecordAlreadyDropped = 2441                  ' Record is dropped
    ErrCombinationExists = 2442                     ' selected combination already exists
    ErrRepIsDropped = 2443                      ' selected capture rep is dropped.
    ErrSAPCodeExists = 2444                     ' SAP code already defined.
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Private Enum ArmScreenMode
    smRefreshOnly                       ' do not change active screen, only refresh active
    smMain
    smAdd
    smUpdate
    smDelete
End Enum

Private ms_Language_Code As String
Private ms_LoginName As String
Private ml_U_code As Long
Private mb_Initialized As Boolean
Private mb_Initializing As Boolean          ' Flag of initializing
Private mc_ScreenLabels                 As Long         'cursor containing screen constants for current component
Private mua_ActiveMode() As ArmScreenMode
Private mb_canUpdate As Boolean

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK EVENTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Event quit()

' FRAMEWORK PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
    grd_main.Visible = aVisible
End Property

Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property

Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property

Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property

Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let LoginName(as_Login As String)
    ms_LoginName = as_Login
End Property

Property Let U_Code(al_Code As Long)
    ml_U_code = al_Code
End Property

Property Let Language_Code(AString As String)
    ms_Language_Code = AString
End Property

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property

Public Sub Load_A_Com()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If mb_Initialized Then
        Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    End If
    
    mc_ScreenLabels = 0

    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    Call grd_main.SetColumns(Array( _
    Join(Array("SR_SAP_Code", "0", "1", "SR_SAP_Code", "#SR_SAP_Code", "", "", "Left"), SEP), _
    Join(Array("SR_Code", "0", "0", "SR_Code", "#SR_Code", "", "", "Left"), SEP), _
    Join(Array("SR_Desc", "2700", "0", "SR_Desc", "#Capture rep.", "", "", "Left"), SEP), _
    Join(Array("BZTXT", "2700", "0", "BZTXT", "#SAP rep.", "", "", "Left"), SEP), _
    Join(Array("z_creation", "1000", "0", "z_creation", "#z_creation", "DATE", "", "Left"), SEP), _
    Join(Array("z_creator", "1500", "0", "z_creator", "#z_creator", "", "", "Left"), SEP), _
    Join(Array("z_last_upd", "1000", "0", "z_last_upd", "#z_last_upd", "DATE", "", "Left"), SEP), _
    Join(Array("z_last_upd_user", "1500", "0", "z_last_upd_user", "#z_last_upd_user", "", "", "Left"), SEP), _
    Join(Array("drop_flag", "500", "0", "drop_flag", "#drop_flag"), SEP), _
    Join(Array("drop_date", "0", "0", "drop_date", "#drop_date", "DATE"), SEP), _
    Join(Array("iConcurrency", "0", "0", "iConcurrency", "#iConcurrency"), SEP)))
    
    grd_main.Requests = Array("EXEC Sales_Reps_SAP_lst '" & ms_LoginName & "'")
    
    mb_Initialized = True

    Exit Sub
ErrHandler:
    Call ErrorMessage("Load_A_COM")
End Sub

Public Sub Unload_A_Com()
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    Dim ll_Index As Long
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.Unload_A_Com
        End Select
    Next
    
    If mc_ScreenLabels <> 0 Then mo_Db.Close (mc_ScreenLabels)
    mc_ScreenLabels = 0

    Set mo_Db = Nothing
    mb_Initialized = False
    Exit Sub
ErrHandler:
    Call ErrorMessage("Unload_A_Com")
End Sub

Public Function Init_control() As Boolean
Dim ll_Index As Long

On Error GoTo ErrHandler
    
    ReDim Preserve mua_ActiveMode(0)
    mua_ActiveMode(UBound(mua_ActiveMode)) = ArmScreenMode.smMain

    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    Call LoadLabels(mo_Db, Me, SCREEN_NAME, ms_Language_Code)
    
    Call grd_main.Refresh
    
    cbo_SR_Code.Request = "EXEC Cap_rpt_login_Lst3 '" & ms_LoginName & "'"
    cbo_SR_SAP_Code.Request = "SELECT BZIRK, CASE BZTXT WHEN '' THEN BZIRK ELSE RTRIM(BZTXT) + ' (' + BZIRK + ')' END AS BZTXT FROM zvslsrep ORDER BY BZTXT, BZIRK"
    
    Call LoadToolbars
    
    mb_canUpdate = GetUserRight
    
    Call Item_Empty
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    Init_control = True
    Exit Function
ErrHandler:
    Init_control = False
    Call ErrorMessage("Init_control")
End Function

Private Property Get activeScreenMode(Optional ByVal al_fromTop As Long = 0) As ArmScreenMode
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mua_ActiveMode))
    activeScreenMode = mua_ActiveMode(UBound(mua_ActiveMode) - al_fromTop)
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".activeScreenMode(Get)")
End Property

Private Sub popScreenMode()
On Error GoTo ErrHandler
    Debug.Assert (UBound(mua_ActiveMode) >= 1)
    ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) - 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenMode")
End Sub


' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, as_Fct & SEP1 & Err.Source, Err.Description, Err.HelpFile, Err.HelpContext
End Sub

' display standard error message
' Params:
' as_Fct (String) - Error CallStack
' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub


' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, '$LOGTYPE$', '$MSG$', '$APP$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage - " & Err.Number & ": " & Err.Description)
End Sub

' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If ENV = LIVE Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If ENV = LIVE Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

Private Function GetNextID(ByVal as_Key As String) As String
On Error GoTo ErrHandler
Dim ls_Data As String

    ls_Data = mo_Db.SQLNextID(as_Key)
    If ls_Data = "" Then
        Err.Raise ArmErr.CompFncFailed, "mo_Db.SQLNextID", "SQLNextID failed for key: " & as_Key
    End If
    GetNextID = ls_Data
    Exit Function
ErrHandler:
    Call ErrorHandler("GetNextID()")
End Function

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        UserControl.Enabled = False
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Enabled = True
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("BeginTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("CommitTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSource As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSource = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSource
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("RollbackTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lc_Labels As Long
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    If mc_ScreenLabels = 0 Then
        ls_Request = "exec screen_csts '" & as_ScreenName & "','" & as_Language & "'"
        mc_ScreenLabels = OpenSQLSafe(ao_Armdb, ls_Request)
    End If
    lc_Labels = mc_ScreenLabels
    
    If lc_Labels = 0 Then
        Exit Sub
    End If
    
    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", ao_Container.Tag, , 1)
        If li_Label >= 0 Then
            ao_Container.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In UserControl.Controls
        
        If HasContainer(lo_Control, ao_Container) Or _
          ((ao_Container Is Me) And (UCase(TypeName(lo_Control)) = "MENU")) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
        
Trace_End:
    Exit Sub
    
Trace_Err:
      
End Sub


Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    MsgText = aDefault
End Function


Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function

Private Function SQLDateTime(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SQLDateTime = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SQLDateTime = "'" & Format(av_Data, "yyyy-mm-dd hh:mm:ss") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDateTime")
End Function


Private Function SQLStr(ByVal as_Value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_Value = "" And ab_EmptyNULL Then
        SQLStr = "NULL"
    Else
        SQLStr = "'" & Replace(Left(as_Value, IIf(Len(as_Value) <= al_MaxLen, Len(as_Value), al_MaxLen)), "'", "''") & "'"
    End If
End Function



Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    as_Request = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)
    
    ReplacePlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholder")
End Function


Public Sub Resize()
On Error GoTo ErrHandler

Dim ll_Index As Long

   If Width < 10800 Or Height < 5200 Then Exit Sub
   
   
    Call grd_main.Move(FRM_SPACE_HOR, FRM_SPACE_VER, Width - (3 * FRM_SPACE_HOR), Height - frm_detail.Height - (2 * FRM_SPACE_VER))
    Call frm_detail.Move(FRM_SPACE_HOR, grd_main.Top + grd_main.Height + FRM_SPACE_VER, grd_main.Width)
    
    Call tlb_list.Move(frm_detail.Width - tlb_list.Width - FRM_SPACE_HOR, FRM_SPACE_VER, tlb_list.Width, frm_detail.Height - (2 * FRM_SPACE_HOR))
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Private Sub grd_Main_SelChange()
On Error GoTo ErrHandler
    Call LoadDataFromGrid(grd_main, grd_main.Row)
    Exit Sub
ErrHandler:
    Call ErrorMessage("grd_main_SelChange")
End Sub

Private Sub tlb_list_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Dim lv_itemKey As Variant

    Call LockScreen(True)
    Select Case as_Role
        Case "A" ' add mode
            Select Case activeScreenMode
                Case smMain
                    Call Item_AddInit
                Case Else
                    Debug.Assert (False)
            End Select
        Case "B" ' update mode
            Select Case activeScreenMode
                Case smMain
                    If grd_main.SelectedCount = 0 Then
                        Call SendMessage(WarMsgSelectRow, "#Please select a row.", ms_Language_Code)
                    ElseIf grd_main.SelectedLine(0, "Drop_Flag") = "X" Then
                        Call SendMessage(RecordAlreadyDropped, "#Item already dropped.", ms_Language_Code)
                    Else
                        Call Item_UpdateInit(grd_main.SelectedKey(0))
                    End If
                Case Else
                    Debug.Assert (False)
            End Select
        Case "C" ' delete mode
            Select Case activeScreenMode
                Case smMain
                    If grd_main.SelectedCount = 0 Then
                        Call SendMessage(WarMsgSelectRow, "#Please select a row.", ms_Language_Code)
                    ElseIf grd_main.SelectedLine(0, "Drop_Flag") = "X" Then
                        Call SendMessage(RecordAlreadyDropped, "#Item already dropped.", ms_Language_Code)
                    Else
                        Call Item_DeleteInit(grd_main.SelectedKey(0))
                    End If
                Case Else
                    Debug.Assert (False)
            End Select
        Case "T" ' exit to previous screen mode
            Select Case activeScreenMode
                Case smMain
                    'exit module
                    RaiseEvent quit
                Case smAdd, smUpdate, smDelete
                    If grd_main.Row <> -1 Then
                        Call LoadDataFromGrid(grd_main)
                    Else
                        Call Item_Empty
                    End If
                    ' pop screen mode
                    Call popScreenMode
                    
                    Call ResetScreen(activeScreenMode)
                    Call UpdateUI
                
                Case Else
                    Debug.Assert (False)
            End Select
                
        Case "H" ' confirm
            Dim lo_exitGrid As ArmGrid
            
            Select Case activeScreenMode
                Case smAdd
                    lv_itemKey = Item_Add ' store new claim
                    Set lo_exitGrid = grd_main
                Case smUpdate
                    lv_itemKey = Item_Update(grd_main.SelectedKey(0), grd_main.SelectedLine(0, "iConcurrency"))  ' update existing claim
                    Set lo_exitGrid = grd_main
                Case smDelete
                    lv_itemKey = Item_Delete(grd_main.SelectedKey(0), grd_main.SelectedLine(0, "iConcurrency"))  ' delete existing claim
                    Set lo_exitGrid = grd_main
                Case Else
                    Debug.Assert (False)
            End Select
            If Not IsEmpty(lv_itemKey) Then
                Dim old_sm As ArmScreenMode
                old_sm = activeScreenMode
                
                Call Item_ExitToGrid(lo_exitGrid, lv_itemKey)
                If old_sm = smAdd Then
                    Debug.Assert (activeScreenMode = smMain)
                    Debug.Assert (lo_exitGrid.Row <> -1)
                    Debug.Assert (lo_exitGrid.SelectedKey(0)(0) = lv_itemKey(0))
                End If
                
                
            End If

        Case "I" ' restore values
            Select Case activeScreenMode
                Case smAdd
                    Call Item_Clear
                Case smUpdate
                    Call LoadDataFromGrid(grd_main)
                Case Else
                    Debug.Assert (False)
            End Select
        Case Else
            Debug.Assert (False)
    End Select

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("tlb_list_action()")
End Sub

Private Sub UserControl_Resize()
    Call Resize
End Sub

Private Sub ResetScreen(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    ' apply face
    Dim lo_ctrl As Object

    Select Case au_Mode
        Case smMain
            Call SetEnabledCtrl(grd_main, True)
            
            ' disable detail controls
            Call SetEnabled(GetContainedControlsChain(frm_detail), False)
            
            
        Case smAdd
            ' we are in Add section
            Call SetEnabledCtrl(grd_main, False)
            
            ' disable detail controls
            Call SetEnabled(GetContainedControlsChain(frm_detail), True)
            
            Call SetEnabled(GetContainedControlsChain(fra_manipulation), False)
        
        Case smUpdate
            ' we are in Update section
            Call SetEnabledCtrl(grd_main, False)
            
            ' disable detail controls
            Call SetEnabled(GetContainedControlsChain(frm_detail), True)
            
            Call SetEnabled(GetContainedControlsChain(fra_manipulation), False)
            Call SetEnabledCtrl(cbo_SR_SAP_Code, False)
            
            
        Case smDelete
            ' we are in PreView section
            Call SetEnabledCtrl(grd_main, False)
            
            ' disable detail controls
            Call SetEnabled(GetContainedControlsChain(frm_detail), False)
            
            Call SetEnabledCtrl(tlb_list, True)

        Case Else
            Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler("ResetScreen()")
End Sub

Private Sub UpdateUI(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly)
On Error GoTo ErrHandler

    ' set active face
    If au_Mode <> smRefreshOnly Then
        If UBound(mua_ActiveMode) = C_SCREENMODE_STACK_SIZE - 1 Then
            ' move array left
            Debug.Print ("Stack is too small. Increase C_SCREENMODE_STACK_SIZE constant please.")
            Dim ll_Index As Long
            For ll_Index = 1 To UBound(mua_ActiveMode)
                mua_ActiveMode(ll_Index - 1) = mua_ActiveMode(ll_Index)
            Next
        Else
            ' allocate one more item
            ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) + 1)
        End If
        mua_ActiveMode(UBound(mua_ActiveMode)) = au_Mode
    End If

    frm_detail.Visible = False
    tlb_list.Redraw = False
    
    ' we have clean screen we can display proper controls
    Select Case activeScreenMode
        Case smMain
            frm_detail.Visible = True
            
            Call tlb_list.DisplayFace(C_TOOLBARFACE_ITEM_LST)
            If Not mb_canUpdate Then
                tlb_list.ButtonVisible("A") = False
                tlb_list.ButtonVisible("B") = False
                tlb_list.ButtonVisible("C") = False
            End If

        Case smAdd
            ' we are in Add section
            frm_detail.Visible = True
            
            Call tlb_list.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)

        Case smUpdate
            ' we are in Update section
            frm_detail.Visible = True
            
            Call tlb_list.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
        Case smDelete
            ' we are in Delete section
            frm_detail.Visible = True
            
            Call tlb_list.DisplayFace(C_TOOLBARFACE_ITEM_MTNC2)
        Case Else
            Debug.Assert (False)
    End Select
    
    tlb_list.Redraw = True

    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateUI()")
End Sub

Private Sub LoadDataFromGrid(ByRef ao_grid As ArmGrid, Optional ByVal ll_Row As Long = -1)
On Error GoTo ErrHandler
    If ll_Row = -1 Then
        ll_Row = ao_grid.Row
    End If

    mb_Initializing = True
    If Not cbo_SR_Code.SearchItem(ao_grid.Data(ll_Row, "SR_Code")) Then
        If cbo_SR_Code.Count = 0 Then
            Call cbo_SR_Code.Load
            If Not cbo_SR_Code.SearchItem(ao_grid.Data(ll_Row, "SR_Code")) Then
                Call cbo_SR_Code.AddItem(Array(ao_grid.Data(ll_Row, "SR_Code"), ao_grid.Data(ll_Row, "SR_Desc") & " - Dropped", 0, "X"), True)
            End If
        Else
            Call cbo_SR_Code.AddItem(Array(ao_grid.Data(ll_Row, "SR_Code"), ao_grid.Data(ll_Row, "SR_Desc") & " - Dropped", 0, "X"), True)
        End If
    End If
    If Not cbo_SR_SAP_Code.SearchItem(ao_grid.Data(ll_Row, "SR_SAP_Code")) Then
        Call cbo_SR_SAP_Code.Load
        Call cbo_SR_SAP_Code.SearchItem(ao_grid.Data(ll_Row, "SR_SAP_Code"))
    End If
    
'    chk_internet.value = IIf(ao_grid.Data(ll_Row, "internet_flag") = "X", 1, 0)
    
    txt_Date.Text = Format(ao_grid.Data(ll_Row, "z_creation"), "dd\/mm\/yyyy")
    Txt_Creator.Text = ao_grid.Data(ll_Row, "z_creator")
    txt_lastUpd.Text = Format(ao_grid.Data(ll_Row, "z_last_upd"), "dd\/mm\/yyyy")
    txt_updUser.Text = ao_grid.Data(ll_Row, "z_last_upd_user")
    txt_dropDate.Text = Format(ao_grid.Data(ll_Row, "drop_date"), "dd\/mm\/yyyy")
    chk_dropped.value = IIf(ao_grid.Data(ll_Row, "drop_flag") = "X", 1, 0)
    
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler("LoadDataFromGrid()")
End Sub

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler("SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_value
            ao_ctrl.BackColor = IIf(ab_value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMGRID", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX" ', "LISTVIEW"
            ao_ctrl.Enabled = ab_value
        End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler("SetEnabledCtrl()")
End Sub


Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object

    For Each lo_Control In Controls
        If Not TypeOf lo_Control.Container Is Sales_reps_SAP_mtnc Then
            If ao_parent.hwnd = lo_Control.Container.hwnd Then
                If TypeOf lo_Control Is Frame Then
                    Dim lo_aux_collection As New Collection
                    Dim ll_i As Long
                    Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                    For ll_i = 1 To lo_aux_collection.Count
                        lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                    Next
                Else
                    Call lo_retCollection.Add(lo_Control)
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler("GetContainedControlsChain()")
End Function

Private Function LoadToolbars() As Boolean
On Error GoTo ErrHandler
    Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 3, 4, $id$"
    Dim ll_Cursor As Long

    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_Cursor, "id", C_TLB_RPT_USER_MTNC_ID) >= 0 Then
        Call tlb_list.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), Left(mo_Db.GetFields(ll_Cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & C_TLB_RPT_USER_MTNC_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    LoadToolbars = True
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If
    LoadToolbars = False
    Call ErrorHandler("LoadToolbars()")
End Function

' initialize add mode
Private Sub Item_AddInit()
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAdd)
    Call Item_Clear
    Call UpdateUI(ArmScreenMode.smAdd)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Sub

' initialize delete mode
Private Sub Item_DeleteInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    Call ResetScreen(ArmScreenMode.smDelete)
    Call Item_Clear
    If grd_main.SearchKey(True, as_detailKey) Then
        Call LoadDataFromGrid(grd_main)
        chk_dropped.value = 1
        txt_dropDate.Text = Format(Now, "dd\/mm\/yyyy")
    End If
    Call UpdateUI(ArmScreenMode.smDelete)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteInit")
End Sub
' initialize update mode
Private Sub Item_UpdateInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smUpdate)
    Call Item_Clear
        
    If grd_main.SearchKey(True, as_detailKey) Then
        Call LoadDataFromGrid(grd_main)
    End If
    Call UpdateUI(ArmScreenMode.smUpdate)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateInit")
End Sub

Private Function Item_Check() As Boolean
On Error GoTo ErrHandler
    Item_Check = False
    
    ' check values and throw message if neccessary
    If cbo_SR_Code.SelectedItem Is Nothing Then
        Call SendMessage(ErrMsgMandatoryAreEmpty, "#Mandatory fields are not filled.", ms_Language_Code)
        Exit Function
    End If
    If cbo_SR_SAP_Code.SelectedItem Is Nothing Then
        Call SendMessage(ErrMsgMandatoryAreEmpty, "#Mandatory fields are not filled.", ms_Language_Code)
        Exit Function
    End If
    ' check if selected rep is not dropped
    If cbo_SR_Code.SelectedItem.GetData(3) = "X" Then
        Call SendMessage(ErrRepIsDropped, "#Selected rep. is dropped.", ms_Language_Code)
        Exit Function
    End If
    
    Item_Check = True
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Check")
End Function

' adds current edited item
Private Function Item_Add() As Variant
Const C_REQ As String = "EXEC Sales_Reps_SAP_sel2 '$SR_SAP_Code$'"
Const C_REQ2 As String = "EXEC Sales_Reps_SAP_sel '$SR_SAP_Code$', '$SR_Code$'"
On Error GoTo ErrHandler
    ' standard check
    If Not Item_Check Then Exit Function
    
    ' check if combination exists
    Dim ll_Cursor As Long
    Dim ls_req As String
    ls_req = Replace(C_REQ2, "$SR_SAP_Code$", cbo_SR_SAP_Code.SelectedItem.Key)
    ls_req = Replace(ls_req, "$SR_Code$", cbo_SR_Code.SelectedItem.Key)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        Call SendMessage(ErrCombinationExists, "#Conversion for SAP_CODE into SR_Code is already defined.", ms_Language_Code)
        Exit Function
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' check if record with SR_SAP_Code exists
    ls_req = Replace(C_REQ, "$SR_SAP_Code$", cbo_SR_SAP_Code.SelectedItem.Key)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        Call SendMessage(ErrSAPCodeExists, "#Conversion for SAP_CODE is already defined.", ms_Language_Code)
        Exit Function
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Dim lb_inTransaction As Boolean
    
    ASC_BeginTransaction mo_Db, "CM_ADD"
    lb_inTransaction = True
    
    Call Item_AddDB
    
    ASC_CommitTransaction mo_Db, "CM_ADD"
    lb_inTransaction = False
    
    Item_Add = CVar(Array(cbo_SR_SAP_Code.SelectedItem.Key))
    Exit Function
ErrHandler:
    If lb_inTransaction Then
        ASC_RollBackTransaction mo_Db, "CM_ADD"
        lb_inTransaction = False
    End If
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    If Err.Number = SQLBadRowAffectedCount Then
        Call MsgBox("Error occured while inserting record, please contact IT")
        Exit Function
    End If

    Call ErrorHandler(Extender.Name & ".Item_Add")
End Function

' update current edited item
Private Function Item_Update(ByVal av_oldKey As Variant, ByVal al_iCOnc As Long) As Variant
On Error GoTo ErrHandler
    Debug.Assert (Not cbo_SR_SAP_Code.SelectedItem Is Nothing)
    Debug.Assert (cbo_SR_SAP_Code.SelectedItem.Key = av_oldKey(0))
    
    ' standard check
    If Not Item_Check Then Exit Function
    
    txt_updUser.Text = ms_LoginName
    txt_lastUpd.Text = Format(Now, "dd\/mm\/yyyy")
    
    ' update data per tab
    Dim lb_inTransaction As Boolean
    
    ASC_BeginTransaction mo_Db, "CM_UPDATE"
    lb_inTransaction = True

    ' save tab
    Call Item_UpdateDB(al_iCOnc)
    
    ASC_CommitTransaction mo_Db, "CM_UPDATE"
    lb_inTransaction = False
    
    Item_Update = CVar(Array(av_oldKey(0)))

    Exit Function
ErrHandler:
    If lb_inTransaction Then
        ASC_RollBackTransaction mo_Db, "CM_UPDATE"
        lb_inTransaction = False
    End If
   If Err.Number = SQLBadRowAffectedCount Then
        Err.Clear
        SendMessage ErrMsgIConcurency, "#Someone changed detail of this record and detail screen will be reloaded.", ms_Language_Code
        Call LoadDataFromGrid(grd_main)
        Exit Function
    End If
    Call ErrorHandler(Extender.Name & ".Item_Update")
End Function

' deletes claim item
Private Function Item_Delete(ByVal av_oldKey As Variant, ByVal al_iCOnc As Long) As Variant
On Error GoTo ErrHandler
    
    Dim lb_inTransaction As Boolean
    
    If SendMessage(WarMsgDoYouRemove, "#Delete record ?", ms_Language_Code, vbQuestion + vbYesNo, "Delete ") = vbYes Then
        
        ASC_BeginTransaction mo_Db, "CM_DEL"
        lb_inTransaction = True
    
        Call Item_DeleteDB(al_iCOnc)
        
        ASC_CommitTransaction mo_Db, "CM_DEL"
        lb_inTransaction = False
    
        Item_Delete = av_oldKey
    End If
    Exit Function
ErrHandler:
    If lb_inTransaction Then
        ASC_RollBackTransaction mo_Db, "CM_DEL"
        lb_inTransaction = False
    End If
   If Err.Number = SQLBadRowAffectedCount Then
        Err.Clear
        SendMessage ErrMsgIConcurency, "#Someone changed detail of this record and detail screen will be reloaded.", ms_Language_Code
        Call LoadDataFromGrid(grd_main)
        Exit Function
    End If
    Call ErrorHandler(Extender.Name & ".Item_Delete")
End Function

Private Sub Item_AddDB()
On Error GoTo ErrHandler
Const C_REQ As String = "exec Sales_Reps_SAP_ins $SR_SAP_Code$, $SR_Code$, $z_creator$"
    Dim ls_req As String
    
    ' common placeholders
    ls_req = Replace(C_REQ, "$SR_SAP_Code$", SQLStr(cbo_SR_SAP_Code.SelectedItem.Key, 6), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SR_Code$", SQLStr(cbo_SR_Code.SelectedItem.Key, 6), , , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$internet_flag$", IIf(chk_internet.value = 1, "X", ""), , , vbTextCompare)
    ls_req = Replace(ls_req, "$z_creator$", SQLStr(ms_LoginName, 8), , , vbTextCompare)

    Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddDb")
End Sub

Private Sub Item_UpdateDB(ByVal al_iCOnc As Long)
On Error GoTo ErrHandler
Const C_REQ As String = "exec Sales_Reps_SAP_upd $SR_SAP_Code$, $SR_Code$, $z_creator$, $iConc$"
    Dim ls_req As String
    
    ' common placeholders
    ls_req = Replace(C_REQ, "$SR_SAP_Code$", SQLStr(cbo_SR_SAP_Code.SelectedItem.Key, 6), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SR_Code$", SQLStr(cbo_SR_Code.SelectedItem.Key, 6), , , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$internet_flag$", IIf(chk_internet.value = 1, "X", ""), , , vbTextCompare)
    ls_req = Replace(ls_req, "$z_creator$", SQLStr(ms_LoginName, 8), , , vbTextCompare)
    ls_req = Replace(ls_req, "$iConc$", al_iCOnc, , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateDb")
End Sub

Private Sub Item_DeleteDB(ByVal al_iCOnc As Long)
On Error GoTo ErrHandler
Const C_REQ As String = "exec Sales_Reps_SAP_del $SR_SAP_Code$, $z_creator$, $iConc$"
    Dim ls_req As String

    ' common placeholders
    ls_req = Replace(C_REQ, "$SR_SAP_Code$", SQLStr(cbo_SR_SAP_Code.SelectedItem.Key, 6), , , vbTextCompare)
    ls_req = Replace(ls_req, "$z_creator$", SQLStr(ms_LoginName, 8), , , vbTextCompare)
    ls_req = Replace(ls_req, "$iConc$", al_iCOnc, , , vbTextCompare)
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteDb")
End Sub
' exits mode to main
Private Sub Item_ExitToGrid(ByRef ao_grid As ArmGrid, ByVal av_gridKey As Variant)
On Error GoTo ErrHandler
    
    ' close detail cursors
    Select Case activeScreenMode
        Case ArmScreenMode.smAdd
        
            Call ao_grid.AddLine(av_gridKey)
            Call ao_grid.SearchKey(True, av_gridKey)
            ao_grid.SelectedLine(0, "BZTXT") = cbo_SR_SAP_Code.SelectedItem.DisplayText
            ao_grid.SelectedLine(0, "SR_Code") = cbo_SR_Code.SelectedItem.Key
            ao_grid.SelectedLine(0, "SR_Desc") = cbo_SR_Code.SelectedItem.DisplayText
            ao_grid.SelectedLine(0, "z_creation") = txt_Date.Text
            ao_grid.SelectedLine(0, "z_creator") = Txt_Creator.Text
            ao_grid.SelectedLine(0, "z_last_upd") = txt_lastUpd.Text
            ao_grid.SelectedLine(0, "z_last_upd_user") = txt_updUser.Text
'            ao_grid.SelectedLine(0, "internet_flag") = IIf(chk_internet.value, "X", "")
            ao_grid.SelectedLine(0, "drop_date") = ""
            ao_grid.SelectedLine(0, "drop_flag") = ""
            ao_grid.SelectedLine(0, "iConcurrency") = 1
    Case ArmScreenMode.smUpdate
    
            Call ao_grid.SearchKey(True, av_gridKey)
            ao_grid.SelectedLine(0, "SR_Code") = cbo_SR_Code.SelectedItem.Key
            ao_grid.SelectedLine(0, "SR_Desc") = cbo_SR_Code.SelectedItem.DisplayText
            ao_grid.SelectedLine(0, "z_last_upd") = txt_lastUpd.Text
            ao_grid.SelectedLine(0, "z_last_upd_user") = txt_updUser.Text
'            ao_grid.SelectedLine(0, "internet_flag") = IIf(chk_internet.value, "X", "")
            ao_grid.SelectedLine(0, "iConcurrency") = ao_grid.SelectedLine(0, "iConcurrency") + 1
        
        Case ArmScreenMode.smDelete
            Call ao_grid.SearchKey(True, av_gridKey)
            Call ao_grid.DeleteSelectedLines
        Case Else
            Debug.Assert (False)
    End Select

    ' pop last item in screen mode stack
    Call popScreenMode
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ExitToGrid")
End Sub

' clear all controls values
Private Sub Item_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Set cbo_SR_Code.SelectedItem = Nothing
    Set cbo_SR_SAP_Code.SelectedItem = Nothing
'    chk_internet.value = 0
    
    txt_Date.Text = Format(Now, "dd\/mm\/yyyy")
    Txt_Creator.Text = ms_LoginName
    txt_lastUpd.Text = Format(Now, "dd\/mm\/yyyy")
    txt_updUser.Text = ms_LoginName
    txt_dropDate.Text = ""
    chk_dropped.value = 0
    
    
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub


Private Sub Item_Empty()
On Error GoTo ErrHandler
    mb_Initializing = True
    Set cbo_SR_SAP_Code.SelectedItem = Nothing
    Set cbo_SR_Code.SelectedItem = Nothing
'    chk_internet.value = 0
    
    txt_Date.Text = ""
    Txt_Creator.Text = ""
    txt_lastUpd.Text = ""
    txt_updUser.Text = ""
    txt_dropDate.Text = ""
    chk_dropped.value = 0

    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Empty")
End Sub


' ************************************************************************************
' ***************************** SECURITY FUNCTIONS ***********************************
' ************************************************************************************

Private Function GetUserRight() As Boolean
Const C_REQ As String = "EXEC Check_Security 'Sales_reps_SAP_mtnc', $LOGINNAME$"
On Error GoTo ErrorHandler
    Dim ll_Cursor As Long
    
' default user rights
    GetUserRight = False

' check admin
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$LOGINNAME$", SQLStr(ms_LoginName)))
    Debug.Assert (ll_Cursor <> 0)
    
    Call mo_Db.First(ll_Cursor)
    While Not mo_Db.EOF(ll_Cursor)
        Select Case mo_Db.GetFields(ll_Cursor, "Action")
        Case "Update"
            GetUserRight = True
        Case Else
            Debug.Assert (False)
        End Select
        Call mo_Db.Next(ll_Cursor)
    Wend
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Function
ErrorHandler:
    If ll_Cursor <> 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("GetUserRight()")
End Function

' ************************************************************************************
